// the grid 
drawGrid = function() {

  var sequence_path1 = ["M600,990", "L600,50"];//middle vertical line
  drawpath( paper, 
            sequence_path1, 
            500, 
            { stroke: 'black', 'stroke-width': 0.5, 'stroke-opacity': 0.5, fill: 'none', 'fill-opacity': 0 }, 
            function()
            {
                //after the horiz. line draw the vertical one
                var sequence_path2 = ["M50,545", "L1090,545"];//middle horizontal line
                drawpath( paper, 
                          sequence_path2, 
                          500, 
                          { stroke: 'black', 'stroke-width': 0.5, 'stroke-opacity': 0.5, fill: 'none', 'fill-opacity': 0 }, 
                          function()
                          {
                              drawArrows(); //callback, when finished draw the arrows     
              	} );
            } );
}
drawBackground = function() {
  var downloadImageBackGround = paper.rect(D_START_X, D_START_Y ,D_WIDTH, D_HEIGHT).attr({"stroke-width": 0, fill: "#E6E6E6", "fill-opacity": 1 });
  var shadowBackGround = paper.rect((D_START_X + 5 ),(D_START_Y + 5 ),D_WIDTH, D_HEIGHT).attr({"stroke-width": 0, fill: "#CCCCCC", "fill-opacity": 0.1 });

  var backGround = paper.rect(D_START_X,D_START_Y,D_WIDTH, D_HEIGHT).attr({"stroke-width": 0, fill: "#ADD8E6", "fill-opacity": 1 });
  
  //the color gradient
  backGround.attr({fill: '#ffffff'});//45-#F7F2ED-#F7EFE6-#F7DEC5
  backGround.toBack();
  
  downloadImageBackGround.toBack();
  shadowBackGround.toBack();
  shadowBackGround.glow({width: 1, opacity: 0.03, color: "#CCCCCC"});
  backGround.node.id = "diargram_arena";
}

drawArrows = function() {

  var horiz_arrow = ["M50,990", "L990,990"];

  drawpath( paper, horiz_arrow, 500, { stroke: 'black', 'stroke-width': 0.5, 'stroke-opacity': 0.5, fill: 'none', 'fill-opacity': 0 }, 
            function() {
                //after the horiz. line draw the vertical one
                var verti_arrow = ["M50,990", "L50,20"];
                drawpath( paper, 
                          verti_arrow, 
                          500, 
                          { stroke: 'black', 'stroke-width': 0.5, 'stroke-opacity': 0.5, fill: 'none', 'fill-opacity': 0 }, 
                          function() {
                              var rightArrow = paper.path("M14.836,7.388L0.112,0.066c0,0,5.579,5.072,5.579,7.322s-5.579,7.353-5.579,7.353L14.836,7.388z");
                              rightArrow.attr({'stroke-width': '0','stroke-opacity': '1','fill': '#000000'}).data('id', 'path_a');
                              rightArrow.transform("t1090,983");
                              var upArrow = paper.path("M7.458,0.042L0.136,14.766c0,0,5.072-5.579,7.322-5.579s7.353,5.579,7.353,5.579L7.458,0.042z");
                              upArrow.attr({fill: '#000000', 'fill-opacity': '1','stroke-width': '0','stroke-opacity': '1'}).data('id', 'path_a');
                              upArrow.transform("t42.5,18"); 
                          } );
            });
   }

drawIndexWords = function() {
  //var text = paper.print(0, 0, theName, theMixPlainBold).attr({"stroke-width": 0, fill: newColor, "font-family": "the_mix_bold-bold, Times", "font-weight": "normal"});

  var lowYaxis = paper.print(23, 975, "Low", theMixPlainBold, 12).attr({"stroke-width": 0, fill: "#333", "font-size": "12px", "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "cursor":"default"});
  var lowXaxis = paper.print(50, 1010, "Low", theMixPlainBold, 12).attr({"stroke-width": 0, fill: "#333", "font-size": "12px", "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "cursor":"default"});
  var highYaxis = paper.print(20, 80, "High", theMixPlainBold, 12).attr({"stroke-width": 0, fill: "#333", "font-size": "12px", "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "cursor":"default"});
  var highXaxis = paper.print(990, 1010, "High", theMixPlainBold, 12).attr({"stroke-width": 0, fill: "#333", "font-size": "12px", "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "cursor":"default"});

  setTimeout(function() {
    var interest = paper.print(500, 1010, "Interest", theMixPlainBold, 22).attr({"stroke-width": 0, fill: "#333", "font-size": "22px", "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "cursor":"default"});
  }, 1000);
  
  setTimeout(function() {
    var power = paper.print(0, 600, "Power", theMixPlainBold, 22).attr({"stroke-width": 0, fill: "#8E8A8A", "font-size": "22px", "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "cursor":"default"});
    power.transform("r-90");
  }, 1200);
  
}

drawBackgroundSlogans = function() {

  setTimeout(function() {
					  
    var sloganConatainer = [];
	
    var keepSatisfied = paper.print(300, 300, "Keep Satisfied", theMixPlainBold, 18).attr({"stroke-width": 0, fill: "#A5A5A5", "font-size": "18px", "font-weight": "bold", "font-family": "the_mix_bold-bold, Times"});
    keepSatisfied.attr({"fill-opacity": "0.0", "cursor":"default"});
    //------------------------------------
    var manageClosely = paper.print(770, 300, "Manage Closely", theMixPlainBold, 18).attr({"stroke-width": 0, fill: "#A5A5A5", "font-size": "18px", "font-weight": "bold", "font-family": "the_mix_bold-bold, Times"});
    manageClosely.attr({"fill-opacity": "0.0", "cursor":"default"});
	//------------------------------------
    var monitor = paper.print(300, 750, "Monitor", theMixPlainBold, 18).attr({"stroke-width": 0, fill: "#A5A5A5", "font-size": "18px", "font-weight": "bold", "font-family": "the_mix_bold-bold, Times"});
    monitor.attr({"fill-opacity": "0.0", "cursor":"default"});

    var minEffort = paper.print(280, 770, "(Minimum Effort)", theMixPlainBold, 14).attr({"stroke-width": 0, fill: "#A5A5A5", "font-size": "14px", "font-family": "the_mix_bold-bold, Times", "font-weight": "normal" });
    minEffort.attr({"fill-opacity": "0.0", "cursor":"default"});
    //------------------------------------
    var keepInformed = paper.print(780, 770, "Keep Informed", theMixPlainBold, 18).attr({"stroke-width": 0, fill: "#A5A5A5", "font-size": "18px", "font-weight": "bold", "font-family": "the_mix_bold-bold, Times"});
    keepInformed.attr({"fill-opacity": "0.0", "cursor":"default"});
    //------------------------------------
    sloganConatainer.push(keepSatisfied, manageClosely, monitor, minEffort, keepInformed);

    for(var i=0; i<sloganConatainer.length; i++) {
      var thisSlogan = sloganConatainer[i];
      thisSlogan.animate({
        "fill-opacity": 0.3
      }, 800);
    }
  }, 1800);
  
}

function drawpath( canvas, pathstr, duration, attr, callback )
{
    var guide_path = canvas.path( pathstr ).attr( { stroke: "none", fill: "none" } );
    var path = canvas.path( guide_path.getSubpath( 0, 1 ) ).attr( attr );
    var total_length = guide_path.getTotalLength( guide_path );
    var last_point = guide_path.getPointAtLength( 0 );
    var start_time = new Date().getTime();
    var interval_length = 50;
    var result = path;        

    var interval_id = setInterval( function()
    {
        var elapsed_time = new Date().getTime() - start_time;
        var this_length = elapsed_time / duration * total_length;
        var subpathstr = guide_path.getSubpath( 0, this_length );            
        attr.path = subpathstr;

        path.animate( attr, interval_length );
        if ( elapsed_time >= duration )
        {
            clearInterval( interval_id );
            if ( callback != undefined ) callback();
                guide_path.remove();
        }                                       
    }, interval_length );  
    return result;
}

// Raphael vaector path of the trash icon
getTheTrashIcon = function() {
  var trashIconPath = "M12.458,2.437v0.542c0,0.079-0.026,0.144-0.076,0.195c-0.051,0.051-0.116,0.076-0.195,0.076h-0.812v8.023   c0,0.469-0.133,0.873-0.398,1.215C10.712,12.83,10.393,13,10.021,13H2.979c-0.373,0-0.691-0.165-0.956-0.495   c-0.265-0.33-0.398-0.728-0.398-1.197V3.25H0.812c-0.079,0-0.144-0.026-0.195-0.076S0.542,3.058,0.542,2.979V2.437   c0-0.079,0.026-0.144,0.076-0.195c0.051-0.051,0.115-0.076,0.195-0.076h2.615L4.02,0.753C4.105,0.545,4.257,0.367,4.477,0.22   C4.697,0.073,4.92,0,5.146,0h2.708C8.08,0,8.303,0.073,8.523,0.22c0.22,0.147,0.372,0.325,0.457,0.533l0.592,1.413h2.615   c0.079,0,0.144,0.026,0.195,0.076C12.433,2.293,12.458,2.358,12.458,2.437z M10.292,11.273V3.25H2.708v8.023   c0,0.125,0.02,0.238,0.059,0.343c0.039,0.104,0.08,0.181,0.123,0.229c0.042,0.047,0.072,0.072,0.089,0.072h7.042   c0.017,0,0.047-0.024,0.089-0.072c0.042-0.048,0.083-0.125,0.123-0.229C10.272,11.512,10.292,11.398,10.292,11.273z M4.875,5.146   v4.875c0,0.079-0.026,0.144-0.076,0.195c-0.051,0.051-0.116,0.076-0.195,0.076H4.062c-0.079,0-0.144-0.026-0.195-0.076   c-0.051-0.051-0.076-0.116-0.076-0.195V5.146c0-0.079,0.026-0.144,0.076-0.195C3.919,4.9,3.984,4.875,4.062,4.875h0.542   c0.079,0,0.144,0.026,0.195,0.076C4.85,5.002,4.875,5.067,4.875,5.146z M4.604,2.166h3.792L7.99,1.176   C7.95,1.126,7.902,1.095,7.846,1.083H5.163C5.106,1.095,5.058,1.126,5.019,1.176L4.604,2.166z M7.042,5.146v4.875   c0,0.079-0.025,0.144-0.076,0.195c-0.051,0.051-0.116,0.076-0.195,0.076H6.229c-0.079,0-0.144-0.026-0.195-0.076   c-0.051-0.051-0.076-0.116-0.076-0.195V5.146c0-0.079,0.026-0.144,0.076-0.195C6.085,4.9,6.15,4.875,6.229,4.875h0.542   c0.079,0,0.144,0.026,0.195,0.076C7.016,5.002,7.042,5.067,7.042,5.146z M9.208,5.146v4.875c0,0.079-0.025,0.144-0.076,0.195   c-0.051,0.051-0.116,0.076-0.195,0.076H8.396c-0.079,0-0.144-0.026-0.195-0.076C8.15,10.165,8.125,10.1,8.125,10.021V5.146   c0-0.079,0.025-0.144,0.076-0.195C8.252,4.9,8.317,4.875,8.396,4.875h0.542c0.079,0,0.144,0.026,0.195,0.076   C9.183,5.002,9.208,5.067,9.208,5.146z";
  return trashIconPath; 
}
// Raphael vaector path of the edit icon ( pencil )
getTheEditIcon = function() {
  var editIconPath = "M7.139,2.291l3.569,3.57L3.57,13H0V9.43L7.139,2.291z M3.115,11.902l0.781-0.781L1.879,9.104L1.098,9.885    v0.918h1.098v1.098H3.115z M7.603,3.939c0-0.126-0.063-0.189-0.189-0.189c-0.057,0-0.106,0.02-0.146,0.06L2.617,8.461    c-0.04,0.04-0.06,0.089-0.06,0.146c0,0.126,0.063,0.189,0.189,0.189c0.057,0,0.106-0.02,0.146-0.06l4.651-4.651    C7.582,4.045,7.603,3.996,7.603,3.939z M13,3.115c0,0.303-0.106,0.561-0.318,0.772l-1.424,1.424l-3.57-3.57l1.424-1.416    C9.319,0.109,9.576,0,9.885,0c0.303,0,0.563,0.109,0.781,0.326l2.016,2.008C12.894,2.557,13,2.817,13,3.115z";
  return editIconPath;   
}