<?php
//============================================================+
// File name   : example_048.php
// Begin       : 2009-03-20
// Last Update : 2013-05-14
//
// Description : Example 048 for TCPDF class
//               HTML tables and table headers
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/*
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: HTML tables and table headers
 * @author Nicola Asuni
 * @since 2009-03-20
*/

// Include the main TCPDF library (search for installation path).

require_once('tcpdf_include.php');

// extend TCPF with custom functions
class MYPDF extends TCPDF {

    // Load table data from file
    public function LoadData($file) {
        // Read file lines
        $lines = file($file);
        $data = array();
        foreach($lines as $line) {
            $data[] = explode(';', chop($line));
        }
        return $data;
    }

    // Colored table
    public function ColoredTable($header,$data) {
        // Colors, line width and bold font
        $this->SetFillColor(255, 0, 0);
        $this->SetTextColor(255);
        $this->SetDrawColor(128, 0, 0);
        $this->SetLineWidth(0.3);
        $this->SetFont('', 'B');
        // Header
        $w = array(40, 35, 40, 45);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $this->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $this->Ln();
        // Color and font restoration
        $this->SetFillColor(224, 235, 255);
        $this->SetTextColor(0);
        $this->SetFont('');
        // Data
        $fill = 0;
        foreach($data as $row) {
            $this->Cell($w[0], 6, $row[0], 'LR', 0, 'L', $fill);
            $this->Cell($w[1], 6, $row[1], 'LR', 0, 'L', $fill);
            $this->Cell($w[2], 6, number_format($row[2]), 'LR', 0, 'R', $fill);
            $this->Cell($w[3], 6, number_format($row[3]), 'LR', 0, 'R', $fill);
            $this->Ln();
            $fill=!$fill;
        }
        $this->Cell(array_sum($w), 0, '', 'T');
    }
}

include("../../lib/config.php");

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('');
$pdf->SetTitle('');
$pdf->SetSubject('');
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
//$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' ', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
//$pdf->SetFont('helvetica', 'B', 12);

// add a page
$pdf->AddPage('p', 'A4');

//$pdf->Write(15, 'Patient Data', '', 0, 'C', true, 0, false, false, 0);

$pdf->SetFont('helvetica', '', 9);

// ----- Start ----

//------------------- Patient Info ---------------------

$host = 'http://'.$_SERVER['HTTP_HOST'].'/shmap-online/'; 

$shid = isset($_GET['shid'])?$_GET['shid']:'';


$selSH_Query = "SELECT ".TBL_CATEGORIES.".category_title,".TBL_STAKEHOLDERS.".* FROM ".TBL_STAKEHOLDERS." 
	INNER JOIN ".TBL_CATEGORIES." ON (".TBL_STAKEHOLDERS.".category_id=".TBL_CATEGORIES.".category_id)
	WHERE ".TBL_STAKEHOLDERS.".id = '".$shid."' ";
$shInfo = $con->getSingleRow($selSH_Query);	

$shName = isset($shInfo['name'])?$shInfo['name']:'';
//-----------------------------------------------------

$html = '
<style>
.tblCard{
	border: 1px solid #CCCCCC;
}
.tblCard tr th{
}
.tblCard tr td {
  height:20px;
  vertical-align: middle;
  text-align: center;
}
.tblCard tr th {
  background-color: #e7e6e6;
  border-right: 1px solid #CCCCCC;
  border-bottom: 1px solid #CCCCCC;
  border-left: 1px solid #CCCCCC;
  border-top: 1px solid #CCCCCC;
  height:20px;
  vertical-align: middle;
  text-align: left;
}
</style>';

$html .= '';							
if(!empty($shInfo))
{
  $html .= '
  <div>
                      <div class="mail-title" style="text-align:center; font-size:25px; float:left;"> <strong>Individual Stakeholder Card</strong> </div>
                      <div style="float:right;"><img src="'.$host.'uploads/stake-holders/'.$shInfo['sh_logo'].'" width="50" height="50" id="shLogo">&nbsp; <strong>'.$shInfo['name'].'</strong></div>
                    </div>
                            
                          <div class="view-mail-wrap">
                          <div class="sparkline8-graph" style="margin-top:10px;">
                            <div class="static-table-list">
                              <table class="tblCard" width="100%">
                                <thead>
                                  <tr>
                                    <th>Category</th>
                                    <th>Abbreviation</th>
                                    <th>Interest</th>
                                    <th>Influence</th>
                                    <th>Current Orientation</th>
                                    <th>Desired Orientation</th>
                                  </tr>
                                </thead>
                                <tbody>
                                  <tr>
                                    <td id="shCatTitle">'.$shInfo['category_title'].'</td>
                                    <td id="shAbbreviation">'.$shInfo['abbreviation'].'</td>
                                    <td id="shInterest">'.$shInfo['orientation_sh_interest'].'</td>
                                    <td id="shInfluence">';
                                  
									if(isset($shInfo['orientation_sh_influence']) &&  $shInfo['orientation_sh_influence']== '7')
									{
										$html .= 'Low';
									}
									elseif(isset($shInfo['orientation_sh_influence']) &&  $shInfo['orientation_sh_influence']== '14')
									{
										$html .= 'Medium';
									}
									elseif(isset($shInfo['orientation_sh_influence']) &&  $shInfo['orientation_sh_influence']== '20')
									{
										$html .= 'High';
									}
									
                          $html .= '</td>
                                    <td id="shCurrentOrientation">';
							
									if(isset($shInfo['sh_current_orientation']) &&  $shInfo['sh_current_orientation']== 'green')
									{
										$html .= 'Supportive';
									}
									elseif(isset($shInfo['sh_current_orientation']) &&  $shInfo['sh_current_orientation']== 'red')
									{
										$html .= 'Resistant';
									}
									elseif(isset($shInfo['sh_current_orientation']) &&  $shInfo['sh_current_orientation']== 'orange')
									{
										$html .= 'Neutral';
									}
							
                             $html .= '</td>
                                    <td id="shDesiredOrientation">';
							 	
									if(isset($shInfo['sh_desired_orientation']) &&  $shInfo['sh_desired_orientation']== 'green')
									{
										$html .= 'Supportive';
									}
									elseif(isset($shInfo['sh_desired_orientation']) &&  $shInfo['sh_desired_orientation']== 'red')
									{
										$html .= 'Resistant';
									}
									elseif(isset($shInfo['sh_desired_orientation']) &&  $shInfo['sh_desired_orientation']== 'orange')
									{
										$html .= 'Neutral';
									}
							
                               $html .= '</td>
                                  </tr>
                                </tbody>
                              </table>
                            </div>
                          </div>
                          <div class="view-mail-content">
                            <div class="sparkline8-graph">
                              <div class="static-table-list">
                                <table class="tblCard" width="100%">
                                  <thead>
                                    <tr>
                                      <th style="text-align:center;">Analysis</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                    <tr>
                                  <td><div id="canvas"></div></td>
                                </tr>
                                <tr>
                                  <td>
                                    <td><div id="canvas"><img width="550" src="'.$host.'uploads/svgs/'.$shInfo['sh_ranking_svg_img'].'" ></div></td>
                                  </td>
                                </tr>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                          <div class="view-mail-content">
                            <div class="sparkline8-graph">
                              <div class="static-table-list">
                                <table class="tblCard" width="100%">
                                  <thead>
                                    <tr>
                                      <th style="text-align:center;">Stakeholder Introduction&nbsp;</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                    <tr>
                                      <td>
									  <div id="sh_intro">'.$shInfo['description'].' </div>
                                      <input for="clear" id="clear" name="clear" title="Erase all names from the grid" type="button" value="Clear" style="display:none;"></td>
                                    </tr>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                          <div class="view-mail-content">
                            <div class="sparkline8-graph">
                              <div class="static-table-list">
                                <table class="tblCard" width="100%">
                                  <tbody>                                    
                                    <tr>
                                      <th width="40%">Summary of RI interaction with stakeholder.</th>
                                      <td width="60%" id="sh_summary_interaction">'.$shInfo['sh_summary_interaction'].'</td>
                                    </tr>
                                    <tr>
                                      <th>What is important for Stakeholder?</th>
                                      <td id="important_for_sh">'.$shInfo['important_for_sh'].'</td>
                                    </tr>
                                    <tr>
                                      <th>How could SH contribute to RI.</th>
                                      <td id="sh_contribute">'.$shInfo['sh_contribute'].'</td>
                                    </tr>
                                    <tr>
                                      <th>How could the stakeholder block RI?</th>
                                      <td id="sh_block">'.$shInfo['sh_block'].'</td>
                                    </tr>
                                    <tr>
                                      <th>Key Issues/Concerns of stakeholder.</th>
                                      <td id="sh_issues_concerns">'.$shInfo['sh_issues_concerns'].'</td>
                                    </tr>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                          <div class="sparkline8-graph">
                            <div class="static-table-list">
                              <table class="tblCard" width="100%">
                                <thead>
                                  <tr>
                                    <th colspan="4" style="text-align:center;">Analysis Updates</th>
                                  </tr>
                                  <tr>
                                    <th width="4%">Sr#</th>
                                    <th width="40%">Update</th>
                                    <th width="56%">Timestamp</th>
                                  </tr>
                                </thead>
                                <tbody id="shUpdates">';
                             
									$counter_rankupd = 0;
									$selQuery_rank_upd = "SELECT * FROM  ".TBL_RANKING_HISTORY." WHERE sh_id='".$shid."' ORDER BY id desc;";
									$rankupdInfo = $con->getMultiRow($selQuery_rank_upd);
									$tot_mappingsInfo = count($rankupdInfo);
									if($tot_mappingsInfo > 0){
										 for($ru=0;$ru<$tot_mappingsInfo;$ru++)
										 {
											$counter_rankupd++;
							
                             $html .= '<tr>
                                      <td>"'.$counter_rankupd.'".</td>
                                      <td id="update_"'.$shInfo['id'].'"_"'.$rankupdInfo[$ru]['id'].'"">"'.isset($rankupdInfo[$ru]['update_detail'])?$rankupdInfo[$ru]['update_detail']:''.'"</td>
                                      <td id="update_timestamp_"'.$shInfo['id'].'"_"'.$rankupdInfo[$ru]['id'].'"">"'.isset($rankupdInfo[$ru]['date_modified'])?date("d-m-Y",strtotime($rankupdInfo[$ru]['date_modified'])):date("d-m-Y",strtotime($rankupdInfo[$ru]['date_added'])).'"</td>
                                    </tr>';
									 }
                                    }
                                $html .= '</tbody>
                              </table>
                            </div>
                          </div>
                          <div class="sparkline8-graph">
                            <div class="static-table-list">
                              <table class="tblCard" width="100%">
                                <thead>
                                  <tr>
                                    <th colspan="4" style="text-align:center;">RI strategy, Responsibilities, execution, milestones achieved.</th>
                                  </tr>
                                  <tr>
                                    <th width="10%">Sr#</th>
                                    <th width="30%">Strategy</th>
                                    <th width="30%">Responsibility</th>
                                    <th width="30%">Key milestones</th>
                                  </tr>
                                </thead>
                                <tbody>';
                                 
									$counter_str = 0;
									$selQuery_str = "SELECT * FROM  ".TBL_STRATEGIES." WHERE sh_id='".$shid."' ORDER BY id desc;";
									$strInfo = $con->getMultiRow($selQuery_str);
									$tot_mappingsInfo = count($strInfo);
									if($tot_mappingsInfo > 0){
										 for($ru=0;$ru<$tot_mappingsInfo;$ru++)
										 {
											$counter_str++;
								
                                  $html .= '<tr>
                                      <td>"'.$counter_str.'".</td>
                                      <td id="strategy_"'.$shInfo['id'].'"_"'.$strInfo[$ru]['id'].'"">"'.isset($strInfo[$ru]['strategy'])?$strInfo[$ru]['strategy']:''.'"</td>
                                      <td id="responsibility_"'.$shInfo['id'].'"_"'.$strInfo[$ru]['id'].'"">"'.isset($strInfo[$ru]['responsibility'])?$strInfo[$ru]['responsibility']:''.'"</td>
                                      <td id="key_milestones_"'.$shInfo['id'].'"_"'.$strInfo[$ru]['id'].'"">"'.isset($strInfo[$ru]['key_milestones'])?$strInfo[$ru]['key_milestones']:''.'"</td>
                                    </tr>';
									 }
                                    }
                                 $html .= ' <tr>
                                      <td colspan="6"></td>
                                  </tr>    
                                </tbody>
                              </table>
                            </div>
                          </div>';
}
$html .= '</div>
          </div>
        </div>
      </div>
    </div>
  </div>';
//echo $html;
//exit;
// output the HTML content

$pdf->writeHTML($html, true, false, false, false, '');
//$pdf->ImageSVG($file = $host."uploads/svgs/".$shInfo['id'].".svg", $x = 15, $y = 30, $w = '', $h = '', $link = 'http://www.tcpdf.org', $align = '', $palign = '', $border = 1, $fitonpage = false);
//-------------------------------------------------------------
//$pdf->writeHTML($html, true, true, true, true, '');

//$pdf->writeHTML($html, true, false, false, false, '');

$pdf->Output('stakerholder-card-'.$shName.'.pdf', 'I');
//============================================================+
// END OF FILE
//============================================================+
?>